/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.sdk.utils;

import com.vistara.sdk.dto.integrations.Attribute;
import com.vistara.sdk.dto.integrations.MapAttributeValue;
import com.vistara.sdk.utils.APIConstants;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtils
implements APIConstants {
    public static List<Attribute> prepareAttrObjFromExcel(String filePath) throws Exception {
        FileInputStream inputStream = new FileInputStream(new File(filePath));
        XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
        ArrayList<Attribute> mappingAttrs = new ArrayList<Attribute>();
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            Attribute mapAttr;
            if (workbook.getSheetAt(i).getSheetName().equals("Instructions") || null == (mapAttr = ExcelUtils.prepareAttrFromSheet(workbook.getSheetAt(i)))) continue;
            mappingAttrs.add(mapAttr);
        }
        if (mappingAttrs != null && !mappingAttrs.isEmpty()) {
            return mappingAttrs;
        }
        return null;
    }

    private static Attribute prepareAttrFromSheet(Sheet excelSheet) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        Attribute attrMapping = new Attribute();
        int colNum = excelSheet.getRow(0).getLastCellNum();
        HashMap<String, Integer> colMapByName = new HashMap<String, Integer>();
        if (excelSheet.getRow(0).cellIterator().hasNext()) {
            for (int j = 0; j < colNum; ++j) {
                colMapByName.put(excelSheet.getRow(0).getCell(j).getStringCellValue(), j);
            }
        }
        Row secondRow = excelSheet.getRow(1);
        String mode = secondRow.getCell((Integer)colMapByName.get("Mode")).getStringCellValue();
        Iterator iterator = excelSheet.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            Row nextRow = (Row)iterator.next();
            String vistaraValue = nextRow.getCell((Integer)colMapByName.get("VistaraAttrValue")).toString();
            String thirdPartyValue = nextRow.getCell((Integer)colMapByName.get("ThirdPartyAttrValue")).toString();
            if ("VISTARA_TO_TENANT".equals(mode)) {
                mappings.put(vistaraValue, thirdPartyValue);
                continue;
            }
            if (!"TENANT_TO_VISTARA".equals(mode)) continue;
            mappings.put(thirdPartyValue, vistaraValue);
        }
        attrMapping.setName(secondRow.getCell((Integer)colMapByName.get("Name")).getStringCellValue());
        attrMapping.setMode(mode);
        attrMapping.setEntityType(secondRow.getCell((Integer)colMapByName.get("VistaraEntity")).getStringCellValue());
        attrMapping.setThirdPartyEntityType(secondRow.getCell((Integer)colMapByName.get("ThirdPartyEntity")).getStringCellValue());
        attrMapping.setAttrName(secondRow.getCell((Integer)colMapByName.get("VistaraAttrName")).getStringCellValue());
        attrMapping.setThirdPartyAttrName(secondRow.getCell((Integer)colMapByName.get("ThirdPartyAttrName")).getStringCellValue());
        ArrayList<MapAttributeValue> clientMapAttrValue = new ArrayList<MapAttributeValue>();
        for (String value : mappings.keySet()) {
            MapAttributeValue mappingValue = new MapAttributeValue();
            if ("VISTARA_TO_TENANT".equals(mode)) {
                mappingValue.setAttrValue(value);
                mappingValue.setThirdPartyAttrValue((String)mappings.get(value));
            } else if ("TENANT_TO_VISTARA".equals(mode)) {
                mappingValue.setAttrValue((String)mappings.get(value));
                mappingValue.setThirdPartyAttrValue(value);
            }
            clientMapAttrValue.add(mappingValue);
        }
        attrMapping.setAttrValues(clientMapAttrValue);
        return attrMapping;
    }
}

