/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.sdk.integrations;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vistara.sdk.client.ClientAPI;
import com.vistara.sdk.dto.Client;
import com.vistara.sdk.dto.integrations.Attribute;
import com.vistara.sdk.dto.integrations.InboundConfiguration;
import com.vistara.sdk.dto.integrations.InstalledIntegration;
import com.vistara.sdk.dto.integrations.OutboundConfiguration;
import com.vistara.sdk.incident.IncidentAPIClient;
import com.vistara.sdk.utils.APIConstants;
import com.vistara.sdk.utils.ExcelUtils;
import com.vistara.sdk.utils.SdkUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IntegrationAPIClient
implements APIConstants {
    private static IntegrationAPIClient _instance = null;
    private static ClientAPI clientAPI = new ClientAPI();
    private String apiBaseURI = null;
    private String tenantId = null;
    private String authType = "Oauth2";
    private String intgUid = null;
    private String installedIntgUid = null;

    public IntegrationAPIClient(String tenantId, String intgUid, String installedIntgUid) throws Exception {
        if (tenantId == null || tenantId.isEmpty()) {
            throw new Exception("Tenant Id should not be null or empty.");
        }
        if (intgUid == null || intgUid.isEmpty()) {
            throw new Exception("Integration Uid cannot be null or empty");
        }
        this.tenantId = tenantId;
        this.intgUid = intgUid;
        this.installedIntgUid = installedIntgUid;
    }

    public IntegrationAPIClient(String tenantId, String installedIntgUid) throws Exception {
        if (tenantId == null || tenantId.isEmpty()) {
            throw new Exception("Tenant Id should not be null or empty.");
        }
        if (installedIntgUid == null || installedIntgUid.isEmpty()) {
            throw new Exception("Installed Integration Id cannot be null or empty");
        }
        this.tenantId = tenantId;
        this.installedIntgUid = installedIntgUid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IntegrationAPIClient getInstance(String tenantId, String intgUid, String installedIntgUid) throws Exception {
        if (_instance != null) return _instance;
        Class<IncidentAPIClient> clazz = IncidentAPIClient.class;
        synchronized (IncidentAPIClient.class) {
            if (_instance != null) return _instance;
            _instance = new IntegrationAPIClient(tenantId, intgUid, installedIntgUid);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return _instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IntegrationAPIClient getInstance(String tenantId, String installedIntgUid) throws Exception {
        if (_instance != null) return _instance;
        Class<IncidentAPIClient> clazz = IncidentAPIClient.class;
        synchronized (IncidentAPIClient.class) {
            if (_instance != null) return _instance;
            _instance = new IntegrationAPIClient(tenantId, installedIntgUid);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return _instance;
        }
    }

    private String getAPIURL(String urlSubStr) throws Exception {
        String apiBaseURI = this.getApiBaseURI();
        SdkUtil.getInstance().setApiBaseURI(apiBaseURI);
        String apiURL = apiBaseURI;
        switch (this.authType) {
            case "Oauth2": {
                apiURL = apiURL + "/api/v2/tenants/" + this.tenantId + "/integrations" + urlSubStr;
                break;
            }
            case "Basic": {
                apiURL = apiURL + "/api/basic/tenants/" + this.tenantId + "/integrations" + urlSubStr;
                break;
            }
            default: {
                throw new Exception("Invalid authentication type: " + this.authType);
            }
        }
        return apiURL;
    }

    public String installIntegration(String jsonPayload, String intgUid) throws Exception {
        if (jsonPayload == null || jsonPayload.isEmpty()) {
            throw new Exception("JsonPayload should not be null or empty.");
        }
        if (intgUid == null || intgUid.isEmpty()) {
            throw new Exception("Integration Uid cannot be null or empty");
        }
        String apiURL = this.getAPIURL("/install/" + intgUid);
        return SdkUtil.getInstance().postRequest(apiURL, jsonPayload);
    }

    public void installIntgInClientsUnderPartner(String jsonPayload, String intgUid, String partnerId) throws Exception {
        List clientList;
        if (jsonPayload == null || jsonPayload.isEmpty()) {
            throw new Exception("JsonPayload should not be null or empty.");
        }
        if (intgUid == null || intgUid.isEmpty()) {
            throw new Exception("Integration Uid cannot be null or empty");
        }
        if (partnerId == null || partnerId.isEmpty()) {
            throw new Exception("Tenant Id should not be null or empty.");
        }
        this.tenantId = partnerId;
        String apiURL = clientAPI.getClientListURI(this.authType, this.tenantId);
        ObjectMapper mapper = new ObjectMapper();
        String response = SdkUtil.getInstance().getRequest(apiURL);
        Map responseMap = (Map)mapper.readValue(response, (TypeReference)new TypeReference<HashMap<String, String>>(){});
        if (Integer.parseInt((String)responseMap.get("status")) == 200 && (clientList = (List)mapper.readValue((String)responseMap.get("status_message"), (TypeReference)new TypeReference<List<Client>>(){})) != null && !clientList.isEmpty()) {
            for (Client client : clientList) {
                this.tenantId = client.getUniqueId();
                this.installIntegration(jsonPayload, intgUid);
            }
        }
    }

    public String createOrUpdateMappings(String jsonPayload, String installedIntgUid) throws Exception {
        if (jsonPayload == null || jsonPayload.isEmpty()) {
            throw new Exception("JsonPayload should not be null or empty.");
        }
        if (installedIntgUid == null || installedIntgUid.isEmpty()) {
            throw new Exception("Installed Integration Id cannot be null or empty");
        }
        String apiURL = this.getAPIURL(installedIntgUid + "/mappingAttr");
        return SdkUtil.getInstance().postRequest(apiURL, jsonPayload);
    }

    public String getIntgMappings(String instIntgId, String attrName) throws Exception {
        StringBuffer url = new StringBuffer();
        url.append("/installed/").append(instIntgId);
        url.append("/mappingAttr?entity=ALERT&name=").append(attrName).append("&intgMode=TENANT_TO_VISTARA");
        String apiURL = this.getAPIURL(url.toString());
        return SdkUtil.getInstance().getRequest(apiURL);
    }

    public String createOrUpdateMappingsFromExcel(String filePath, String mode) throws Exception {
        if (this.installedIntgUid == null || this.installedIntgUid.isEmpty()) {
            throw new Exception("Installed Integration Id cannot be null or empty");
        }
        if (filePath == null || filePath.isEmpty()) {
            throw new Exception("File path cannot be null or empty");
        }
        if (mode == null || mode.isEmpty()) {
            throw new Exception("Mode cannot be null or empty");
        }
        String apiURL = this.getAPIURL("/installed/" + this.installedIntgUid + "/mappingAttr");
        return SdkUtil.getInstance().postRequest(apiURL, this.prepareIntgObjFromExcel(filePath, mode));
    }

    private InstalledIntegration prepareIntgObjFromExcel(String filePath, String mode) throws Exception {
        try {
            if (filePath == null || filePath.isEmpty()) {
                throw new Exception("Filepath cannot be empty");
            }
            if (mode == null || mode.isEmpty()) {
                throw new Exception("Mode cannot be empty");
            }
            InstalledIntegration instIntg = new InstalledIntegration();
            if ("VISTARA_TO_TENANT".equals(mode)) {
                OutboundConfiguration outboundConf = new OutboundConfiguration();
                List<Attribute> outboundMappings = ExcelUtils.prepareAttrObjFromExcel(filePath);
                if (null == outboundMappings || outboundMappings.isEmpty()) {
                    throw new Exception("Failed to prepare mappings from Excel");
                }
                outboundConf.setMapAttributes(outboundMappings);
                instIntg.setOutboundConfig(outboundConf);
            } else if ("TENANT_TO_VISTARA".equals(mode)) {
                InboundConfiguration inboundConf = new InboundConfiguration();
                List<Attribute> inboundMappings = ExcelUtils.prepareAttrObjFromExcel(filePath);
                if (null == inboundMappings || inboundMappings.isEmpty()) {
                    throw new Exception("Failed to prepare mappings from Excel");
                }
                inboundConf.setMapAttributes(inboundMappings);
                instIntg.setInboundConfig(inboundConf);
            }
            return instIntg;
        }
        catch (Exception e) {
            throw new Exception("Failed to prepare mappings");
        }
    }

    public void setBasicAuthentication(String apiUserName, String apiPassword) throws Exception {
        if (apiUserName == null || apiUserName.isEmpty()) {
            throw new Exception("API UserName should not be null or empty.");
        }
        if (apiPassword == null || apiPassword.isEmpty()) {
            throw new Exception("API Password should not be null or empty.");
        }
        this.authType = "Basic";
        SdkUtil.getInstance().setApiUserName(apiUserName);
        SdkUtil.getInstance().setApiPassword(apiPassword);
        SdkUtil.getInstance().setAuthType(this.authType);
    }

    public void setOAUTH2Authentication(String apiKey, String apiSecret) throws Exception {
        if (apiKey == null || apiKey.isEmpty()) {
            throw new Exception("API Key should not be null or empty.");
        }
        if (apiSecret == null || apiSecret.isEmpty()) {
            throw new Exception("API Secret should not be null or empty.");
        }
        this.authType = "Oauth2";
        SdkUtil.getInstance().setApiKey(apiKey);
        SdkUtil.getInstance().setApiSecret(apiSecret);
        SdkUtil.getInstance().setAuthType(this.authType);
    }

    public void setWebhookAuthentication() throws Exception {
        this.authType = "None";
        SdkUtil.getInstance().setAuthType(this.authType);
    }

    public String getApiBaseURI() {
        if (this.apiBaseURI == null) {
            return "https://api.vistara.io";
        }
        return this.apiBaseURI;
    }

    public void setApiBaseURI(String apiBaseURI) {
        this.apiBaseURI = apiBaseURI;
    }

    public static void main(String[] args) throws Exception {
    }
}

